/*
 * Decompiled with CFR 0.152.
 */
package Calc4M.midp1;

import Calc4M.midp1.Key;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public abstract class DisplayList
extends Canvas {
    public static final int DEFAULT_COLOR_BACKGROUND = 0xFFFFFF;
    public static final int DEFAULT_COLOR_BORDER = 0x808080;
    public static final int DEFAULT_COLOR_TEXT = 0;
    public static final int DEFAULT_COLOR_SELECTED_TEXT = 0xFFFFFF;
    public static final int DEFAULT_COLOR_SELECTED_BACKGROUND = 0xC08888;
    public static final int DEFAULT_COLOR_ARROW = 0x5050A0;
    public static final int DEFAULT_COLOR_LIST = 0x8888EE;
    public static final int DEFAULT_COLOR_LIST_TEXT = 0xFFFFFF;
    public int colorBackground = 0xFFFFFF;
    public int colorBorder = 0x808080;
    public int colorText = 0;
    public int colorSelectedText = 0xFFFFFF;
    public int colorSelectedBackground = 0xC08888;
    public int colorArrow = 0x5050A0;
    public int colorList = 0x8888EE;
    public int colorListText = 0xFFFFFF;
    protected String leftButtonText = "Ok";
    protected String rightButtonText = "Cancel";
    protected int padding = 3;
    protected Font font;
    protected int fontHeight;
    protected Displayable nextScreen;
    protected int currItem;
    protected int topItem;
    protected int maxItemCount;
    protected int textHeight;
    protected static Display display;
    protected boolean drawBorder = false;
    protected int top = -1;
    protected int bottom = -1;
    protected int left = -1;
    protected int right = -1;
    protected boolean displayList = true;
    protected String[] items;
    protected String[] shortcuts;

    public void prepareShow(Display display, Displayable nextScreen, boolean fullScreenMode) {
        this.prepareShow(display, nextScreen, fullScreenMode, 64, 0, 8);
    }

    public void prepareShow(Display display, Displayable nextScreen, boolean fullScreenMode, int fontFace, int fontStyle, int fontSize) {
        this.prepareShow(display, nextScreen, fullScreenMode, Font.getFont((int)fontFace, (int)fontStyle, (int)fontSize));
    }

    public void prepareShow(Display display, Displayable nextScreen, boolean fullScreenMode, Font font) {
        DisplayList.display = display;
        this.nextScreen = nextScreen;
        this.font = font;
    }

    protected void switchToNextScreen() {
        display.setCurrent(this.nextScreen);
    }

    protected abstract void handleKeyPress(int var1, boolean var2);

    protected boolean internalHandleKey(int keyCode) {
        boolean handled = false;
        switch (this.getGameAction(keyCode)) {
            case 1: {
                --this.currItem;
                handled = true;
                break;
            }
            case 6: {
                ++this.currItem;
                handled = true;
            }
        }
        if (handled) {
            if (this.currItem < 0) {
                this.currItem = this.items.length - 1;
            }
            if (this.currItem > this.items.length - 1) {
                this.currItem = 0;
            }
            if (this.currItem < this.topItem) {
                this.topItem = this.currItem;
            }
            if (this.currItem > this.topItem + this.maxItemCount - 1) {
                this.topItem = this.currItem - this.maxItemCount + 1;
            }
            this.repaint();
        }
        return handled;
    }

    private int positionToItem(int x, int y) {
        if (x < this.left || x > this.right || y < this.top || y > this.bottom) {
            return -1;
        }
        return (y - this.padding / 2 - (this.drawBorder ? 1 : 0) - this.top) / this.textHeight + this.topItem;
    }

    public void keyPressed(int keyCode) {
        boolean handled = this.internalHandleKey(keyCode);
        int key = Key.keyCode2Key(keyCode, this);
        if (!this.displayList || key != 21) {
            switch (key) {
                case 20: 
                case 21: 
                case 22: {
                    handled = true;
                    this.switchToNextScreen();
                }
            }
        }
        this.handleKeyPress(key, handled);
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
        this.internalHandleKey(keyCode);
    }

    public void pointerPressed(int x, int y) {
        int i = this.positionToItem(x, y);
        if (i >= 0) {
            this.currItem = i;
            this.handleKeyPress(17, false);
        } else {
            if (this.displayList && y > this.bottom - this.textHeight) {
                if (x < (this.left + this.right) / 2) {
                    this.handleKeyPress(21, false);
                } else {
                    this.switchToNextScreen();
                }
            }
            this.switchToNextScreen();
        }
    }

    public void pointerDragged(int x, int y) {
        int i = this.positionToItem(x, y);
        if (i >= 0) {
            this.currItem = i;
            this.repaint();
        } else {
            super.pointerDragged(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
    }

    protected void sizeChanged(int w, int h) {
        this.fontHeight = this.font.getHeight();
        this.textHeight = this.fontHeight + 2 * (this.padding / 2);
        this.top = 0;
        this.left = 0;
        this.bottom = this.getHeight();
        if (this.displayList) {
            this.bottom -= this.textHeight + 2;
        }
        this.maxItemCount = (this.bottom - (this.drawBorder ? 2 : 0)) / this.textHeight;
        this.topItem = 0;
        this.right = this.getWidth();
        if (this.currItem > this.topItem + this.maxItemCount - 1) {
            this.topItem = this.currItem - this.maxItemCount + 1;
        }
    }

    public void paint(Graphics g) {
        int currPos;
        int i;
        int border = this.drawBorder ? 1 : 0;
        int height = this.bottom - this.top;
        int width = this.right - this.left;
        g.setClip(this.left, this.top, this.getWidth(), this.getHeight());
        g.setColor(this.colorBackground);
        g.fillRect(this.left, this.top, width, height);
        if (this.displayList) {
            g.setColor(this.colorList);
            g.fillRect(0, this.bottom, this.getWidth(), this.getHeight() - this.bottom);
            g.setColor(this.colorBorder);
            g.drawLine(0, this.bottom, this.getWidth(), this.bottom);
            g.setColor(this.colorListText);
            g.drawString(this.leftButtonText, this.padding, this.getHeight(), 36);
            g.drawString(this.rightButtonText, this.getWidth() - this.padding, this.getHeight(), 40);
            g.setClip(this.left, this.top, width, height);
        }
        if (this.drawBorder) {
            g.setColor(this.colorBorder);
            g.drawRect(this.left, this.top, width - 1, height - 1);
        }
        g.setClip(this.left, this.top, width - 1, height - 1);
        for (i = this.topItem; i < this.items.length; ++i) {
            currPos = this.top + (i - this.topItem) * this.textHeight + border;
            if (i != this.currItem) continue;
            g.setColor(this.colorSelectedBackground);
            g.fillRect(this.left + border, currPos, width - 2 * border, this.textHeight + this.padding / 2);
        }
        g.setColor(this.colorArrow);
        if (this.topItem > 0) {
            g.drawLine(this.left + width / 2, this.top, this.left + (width - this.textHeight) / 2, this.top + this.textHeight);
            g.drawLine(this.left + (width - this.textHeight) / 2, this.top + this.textHeight, this.left + (width + this.textHeight) / 2, this.top + this.textHeight);
            g.drawLine(this.left + (width + this.textHeight) / 2, this.top + this.textHeight, this.left + width / 2, this.top);
        }
        if (this.topItem < this.items.length - this.maxItemCount) {
            g.drawLine(this.left + width / 2, this.bottom, this.left + (width - this.textHeight) / 2, this.bottom - this.textHeight);
            g.drawLine(this.left + (width - this.textHeight) / 2, this.bottom - this.textHeight, this.left + (width + this.textHeight) / 2, this.bottom - this.textHeight);
            g.drawLine(this.left + (width + this.textHeight) / 2, this.bottom - this.textHeight, this.left + width / 2, this.bottom);
        }
        g.setFont(this.font);
        for (i = this.topItem; i < this.items.length; ++i) {
            currPos = this.top + (i - this.topItem) * this.textHeight + border + this.padding / 2;
            if (i == this.currItem) {
                g.setColor(this.colorSelectedText);
            } else {
                g.setColor(this.colorText);
            }
            g.drawString(this.items[i], this.left + border + this.padding, currPos, 20);
            if (this.shortcuts == null || this.shortcuts[i] == null || this.shortcuts[i].equals("")) continue;
            g.drawString(this.shortcuts[i], this.right - this.padding, currPos, 24);
        }
    }
}

